function m=moments_nn(y,x,nn,beta)

% The lagged y is the first element of x

    z=x*beta;
    xx=x(:,2:size(x,2));
    ylag=x(:,1);
    xb=xx*beta(2:length(beta));
    k=size(xx,2);
    nobs=size(nn,1);
    m=zeros(nobs,2*3*k+4);
    for i=1:nobs
        Ti=nn(i,2)-nn(i,1)+1;
        if Ti>=3
            yi=y(nn(i,1):nn(i,2));
            xbi=xb(nn(i,1):nn(i,2));
            zi=z(nn(i,1):nn(i,2));
            xxi=xx(nn(i,1):nn(i,2),:);
            ylagi=ylag(nn(i,1):nn(i,2));
            for t=1:Ti-2
                for s=t+1:Ti-1
                    for r=s+1:Ti
                        mm1 = (1-yi(t))*yi(s)*(1-yi(r))*exp(zi(t)-zi(s)) ...
                            + (1-yi(t))*yi(s)*yi(r)*exp(zi(t)-zi(r)) ...
                            - yi(t)*(1-yi(s)) ...
                            + yi(t)*yi(s)*(1-yi(r))*(exp(zi(r)-zi(s))-1);
                        mm1=mm1/(exp(zi(t)-xbi(s))+exp(zi(t)-xbi(r))+1+exp(xbi(r)-xbi(s)));
                        mm2 = (1-yi(t))*(1-yi(s))*yi(r)*(exp(zi(s)-zi(r))-1) ...
                            - (1-yi(t))*yi(s) ...
                            + yi(t)*(1-yi(s))*(1-yi(r))*exp(zi(r)-zi(t)) ...
                            + yi(t)*(1-yi(s))*yi(r)*exp(zi(s)-zi(t));
                        mm2=mm2/(exp(xbi(s)-xbi(r))+1+exp(xbi(r)-zi(t))+exp(xbi(s)-zi(t)));
                        m(i,:)=m(i,:)+ ...
                            [mm1*[1 ylagi(t) xxi(t,:) xxi(s,:) xxi(r,:)] ...
                             mm2*[1 ylagi(t) xxi(t,:) xxi(s,:) xxi(r,:)]];
                    end
                end
            end
            m(i,:)=m(i,:)*(Ti-1)/nchoosek(Ti,3);
        end
    end
    
end
            


